import sys

target = sys.argv[1]
n = int(sys.argv[2])

output = open('script.sh', 'w')
for i in range(n):
    script_name = "script_%s_%d.sh" % (target, i)
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#$ -cwd
#$ -e ./script_%s_%d.stderr
#$ -o ./script_%s_%d.stdout
#$ -v PYTHONPATH=/home/mdehoon/lib/python3.7/site-packages,LANG=en_US
#$ -l mem_free=4G
#$ -l h_vmem=4G
python filter.py %s %d
""" % (target, i, target, i, target, i))
    handle.close()
    output.write('qsub -r n %s\n' % script_name)

output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
